<?php

namespace App\Models\Regras;

use App\Models\Entity\Cartao;
use App\Models\Entity\CartaoCliente;
use App\Models\Entity\Cliente;
use App\Models\Entity\EntradaCredito;
use App\Models\Entity\SituacaoCartao;
use App\Models\Facade\ClienteDB;
use Exception;
use Illuminate\Support\Facades\Auth;

class ClienteRegras
{
    private static $error = null;

    public static function salvar($p)
    {
        $p->cartao = self::validaCartao($p->codigo);
        
        if(!$p->cartao) throw new Exception(self::$error);

        $cliente = self::saveCliente($p);
        $p->cartaoCliente = self::saveNovoCartaoCliente($p, $cliente);
        Cliente::where('id', $cliente->id)->update(['fk_cartao_cliente' => $p->cartaoCliente->id]);
        self::saveEntradaCreditoRefCaucao($p);
        return $cliente;
    }

    public static function alterar($p)
    {
        $p->cartao = self::validaCartao($p->codigo, $p->id);

        if(!$p->cartao) throw new Exception(self::$error);

        $cliente = self::saveCliente($p);
        
        //verifica se cartão do cliente no BD = ao submetido do Formulário
        if($cliente->fk_cartao != $p->cartao->id) {
            self::saveDevolucao($cliente);
            $p->cartaoCliente = self::saveNovoCartaoCliente($p, $cliente);
            self::saveEntradaCreditoRefCaucao($p);
        }else {
            self::editaCartaoCliente($p, $cliente);
        }
        return $cliente;
    }

    
    public static function saveCliente($p)
    {
        //INSERT
        if(!$p->id) {
            $cliente = new Cliente();
            $cliente->created_at = date('Y-m-d H:i:s');
            $cliente->fk_usuario = Auth::user()->id;
        } 
        
        //UPDATE
        else {
            $cliente = Cliente::find($p->id);            
            $cliente->updated_at = date('Y-m-d H:i:s');
            $cliente->fk_usuario_alt = Auth::user()->id;
        }

        $cliente->fk_cartao = $p->cartao->id;
        $cliente->fk_escola = $p->escola;
        $cliente->nome = $p->nome;
        $cliente->cpf = $p->cpf ? preg_replace('/[^0-9]/', '', $p->cpf) : null;
        $cliente->telefone = $p->telefone ?? null;
        $cliente->fk_tipo_cliente = $p->tipo;
        $cliente->dia_vencimento = $p->diaVencimento;
        $cliente->observacao = $p->observacao;
        $cliente->save();

        

        return $cliente;
    }

    public static function saveNovoCartaoCliente($p, $cliente)
    {
        $cartaoCliente = CartaoCliente::create([
            'fk_cartao' => $p->cartao->id,
            'fk_cliente_titular' => $cliente->id,
            'nome' => $p->nome,
            'cpf' => $p->cpf ? preg_replace('/[^0-9]/', '', $p->cpf) : null,
            'telefone' => $p->telefone ?? null,
            'fk_tipo_cliente' => $p->tipo,
            'fk_tipo_pagamento' => $p->tipoPagamento,
            'valor_atual' => 0,
            'valor_cartao' => formatarMoeda($p->valorCartao),
            'observacao' => $p->observacao ?? null,
            'devolvido' => 'N',
            'status' => 2,
            'created_at' => date('Y-m-d H:i:s'),
            'fk_usuario' => Auth::user()->id,
        ]);

    
        Cartao::where('id', $p->cartao->id)->update(['fk_situacao' => 2]);

        return $cartaoCliente;
    }

    public static function editaCartaoCliente($p, $cliente)
    {
        $cartaoCliente = CartaoCliente::find($cliente->fk_cartao_cliente);
        $cartaoCliente->fk_cartao = $p->cartao->id;
        $cartaoCliente->fk_cliente_titular = $cliente->id;
        $cartaoCliente->nome = $p->nome;
        $cartaoCliente->cpf = $p->cpf ? preg_replace('/[^0-9]/', '', $p->cpf) : null;
        $cartaoCliente->telefone = $p->telefone ?? null;
        $cartaoCliente->fk_tipo_cliente = $p->tipo;
        $cartaoCliente->observacao = $p->observacao ?? null;
        $cartaoCliente->updated_at = date('Y-m-d H:i:s');
        //$cartaoCliente->fk_usuario_alt = Auth::user()->id;
        //$cartaoCliente->devolvido = 'N';
        //$cartaoCliente->fk_tipo_pagamento = $p->tipoPagamento;
        //$cartaoCliente->valor_atual = 0;
        //$cartaoCliente->valor_cartao = formatarMoeda($p->valorCartao);
        //$cartaoCliente->status = 2;
        $cartaoCliente->save();
    }

    public static function saveEntradaCreditoRefCaucao($p)
    {
        EntradaCredito::create([
            'fk_cartao_cliente' => $p->cartaoCliente->id,
            'valor' => formatarMoeda($p->valorCartao),
            'fk_tipo_pagamento' => $p->tipoPagamento,
            'observacao' => 'Crédito Cartão aluno: '.$p->nome,
            'data' => date('Y-m-d H:i:s'),
            'fk_usuario' => Auth::user()->id
        ]);
    }

    public static function saveDevolucao($cliente)
    {
        CartaoCliente::where('id', $cliente->fk_cartao_cliente)->update(['status' => 1, 'devolvido' => 'S']);
        
        Cartao::where('id', $cliente->fk_cartao)->update(['fk_situacao' => 1]);
    }

    public static function validaCartao($codigo, $id=null)
    {
        $cartao = Cartao::where('codigo', $codigo)->first();
        
        if(!$cartao){
            self::$error = "Cartão inválido.";
            return false;
        }

        if(!$id) { //validação no cadastro
            if($cartao->fk_situacao == 2){
                self::$error = "Este cartão já está em uso. Por favor, passe outro cartão.";
                return false;
            }
        }
        else { //validação somente na alteração
            $cliente = ClienteDB::find($id);

            if($cliente->codigo != $codigo) { //verifica se o cartão do cliente no BD != do informado no form
                if($cartao->fk_situacao == 2){
                    self::$error = "Este cartão já está em uso. Por favor, passe outro cartão.";
                    return false;
                }
            }
        }
            
        return $cartao;
    }

}